#include <algorithm>
#include <iomanip>
#include <iostream>
#include <iterator>
#include <map>
#include <set>
#include <utility>
#include <vector>

using namespace std;

typedef long long ll;
typedef long double ld;
typedef unsigned long long ull;

#define PI 3.1415926535897932384626433832795
// const ld pi = acos(-1.0);

const int INF = 1e9;
const ll LINF = 1e18;

const ll MOD = 1000000007;
const ll FMOD = 998244353;

const ld eps = 1e-9;

int main() {
  ios_base::sync_with_stdio(NULL);
  cin.tie(NULL);
  cout.tie(NULL);

  ll n, change = 0, result = 0;
  cin >> n;
  map<ll, pair<ll, ll>> mult;
  set<int> k;
  vector<ll> arr(n);

  for (ll i = 0; i < n; i++) {
    ll temp;
    cin >> temp;
    if (mult.count(temp) == 0) {
      mult[temp] = make_pair(temp, 1);
    } else {
      mult[temp].second += 1;
    }
    arr[i] = temp;
  }

  sort(arr.begin(), arr.end());

  for (ll i = n - 1; i >= 0; i--) {
    ll index_i = arr[i];
    // cout << index_i << "\n";
    if (mult.count(index_i) != 0 && k.count(index_i) == 0) {
      ll last = mult[index_i].first;

      if (last - change < 0) {
        break;
      }

      result += (last - change) * (mult[index_i].second);
      change += mult[index_i].second;

      // cout << result << "\n";
      // arr.erase(arr.end());
      // mult.erase(index_i);
      k.insert(index_i);
      // i--;
    }
  }

  cout << result;

  return 0;
}
